@extends('layouts.auth')
@section('page-title')
    {{ __('Reset Password') }}
@endsection
@section('language-bar')
    <div class="lang-dropdown-only-desk">
        <li class="dropdown dash-h-item drp-language">
            <a class="dash-head-link dropdown-toggle btn" href="#" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="drp-text"> {{ ucfirst($language->fullName) }}
                </span>
            </a>
            <div class="dropdown-menu dash-h-dropdown dropdown-menu-end">
                @foreach (languages() as $code => $language)
                    <a href="{{ route('password.request', $code) }}" tabindex="0"
                        class="dropdown-item dropdown-item {{ $lang == $code ? 'active' : '' }}">
                        <span>{{ ucFirst($language) }}</span>
                    </a>
                @endforeach
            </div>
        </li>
    </div>
@endsection
@section('content')

    <div class="auth-wrapper login-page">
        <div class="bottom-bg">
            <svg width="69" height="129" viewBox="0 0 69 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M2.6351 123.878C3.41663 123.079 4.68262 123.075 5.47146 123.847C6.2603 124.619 6.27396 125.895 5.50185 126.684C4.72031 127.482 3.45432 127.486 2.66548 126.714C1.87664 125.942 1.85356 124.676 2.6351 123.878Z"
                    fill="white" />
                <path
                    d="M10.2806 116.066C11.0527 115.277 12.3281 115.263 13.117 116.035C13.9058 116.808 13.9195 118.083 13.1474 118.872C12.3658 119.67 11.0904 119.684 10.3016 118.912C9.52215 118.13 9.50849 116.855 10.2806 116.066Z"
                    fill="white" />
                <path
                    d="M2.63314 108.58C3.40526 107.792 4.68067 107.778 5.46951 108.55C6.25835 109.322 6.27201 110.597 5.4999 111.386C4.71837 112.185 3.44295 112.198 2.65411 111.426C1.86507 110.635 1.86103 109.369 2.63314 108.58Z"
                    fill="white" />
                <path
                    d="M17.9265 108.255C18.6986 107.466 19.993 107.452 20.7722 108.215C21.5611 108.987 21.5747 110.262 20.7932 111.061C20.0211 111.849 18.7457 111.863 17.9568 111.091C17.168 110.319 17.1543 109.043 17.9265 108.255Z"
                    fill="white" />
                <path
                    d="M10.279 100.769C11.0511 99.98 12.3359 99.9567 13.1248 100.729C13.9136 101.501 13.9273 102.776 13.1458 103.575C12.3736 104.364 11.0982 104.377 10.3094 103.605C9.51092 102.824 9.50688 101.558 10.279 100.769Z"
                    fill="white" />
                <path
                    d="M2.62177 93.2737C3.39389 92.4848 4.67872 92.4616 5.46756 93.2337C6.25639 94.0058 6.27006 95.2812 5.48853 96.0797C4.71641 96.8685 3.45061 96.8916 2.65215 96.1101C1.85369 95.3285 1.84965 94.0625 2.62177 93.2737Z"
                    fill="white" />
                <path
                    d="M25.5814 100.433C26.3629 99.6349 27.6385 99.6403 28.4178 100.403C29.2066 101.175 29.2203 102.451 28.4481 103.239C27.676 104.028 26.3912 104.051 25.6024 103.279C24.8135 102.507 24.7999 101.232 25.5814 100.433Z"
                    fill="white" />
                <path
                    d="M17.9339 92.9479C18.7155 92.1494 19.9815 92.1454 20.7703 92.9175C21.5591 93.6896 21.5728 94.965 20.8007 95.7539C20.0286 96.5427 18.7437 96.566 17.9549 95.7939C17.1564 95.0124 17.1524 93.7464 17.9339 92.9479Z"
                    fill="white" />
                <path
                    d="M10.2757 85.4527C11.0573 84.6542 12.3232 84.6502 13.1121 85.4223C13.9009 86.1944 13.9146 87.4698 13.1425 88.2586C12.3704 89.0475 11.0951 89.0802 10.2967 88.2987C9.49823 87.5171 9.49419 86.2511 10.2757 85.4527Z"
                    fill="white" />
                <path
                    d="M2.62826 77.9668C3.40979 77.1684 4.66617 77.1549 5.46463 77.9364C6.25346 78.7086 6.26713 79.984 5.49502 80.7728C4.7229 81.5616 3.43807 81.5849 2.64923 80.8128C1.85077 80.0313 1.84673 78.7653 2.62826 77.9668Z"
                    fill="white" />
                <path
                    d="M33.2279 92.6221C34.0094 91.8236 35.285 91.829 36.0642 92.5917C36.8531 93.3638 36.8667 94.6392 36.0946 95.4281C35.3225 96.2169 34.0471 96.2306 33.2583 95.4585C32.4694 94.6863 32.4463 93.4206 33.2279 92.6221Z"
                    fill="white" />
                <path
                    d="M25.5794 85.1361C26.361 84.3377 27.627 84.3336 28.4158 85.1057C29.2046 85.8779 29.2183 87.1533 28.4462 87.9421C27.6741 88.731 26.3987 88.7446 25.6098 87.9725C24.8114 87.191 24.7979 85.9346 25.5794 85.1361Z"
                    fill="white" />
                <path
                    d="M17.9222 77.641C18.7037 76.8426 19.9697 76.8385 20.7586 77.6106C21.5474 78.3827 21.5611 79.6582 20.789 80.447C20.0168 81.2358 18.751 81.2589 17.9526 80.4774C17.1541 79.6959 17.1407 78.4395 17.9222 77.641Z"
                    fill="white" />
                <path
                    d="M10.2747 70.1555C11.0563 69.3571 12.3127 69.3436 13.1111 70.1252C13.8999 70.8973 13.9136 72.1727 13.1415 72.9615C12.3694 73.7504 11.094 73.764 10.3051 72.9919C9.50667 72.2104 9.49321 70.954 10.2747 70.1555Z"
                    fill="white" />
                <path
                    d="M2.60678 62.6507C3.38831 61.8522 4.65431 61.8482 5.44315 62.6203C6.23198 63.3924 6.24565 64.6678 5.47353 65.4566C4.70141 66.2455 3.426 66.2592 2.63716 65.487C1.84832 64.7149 1.82524 63.4491 2.60678 62.6507Z"
                    fill="white" />
                <path
                    d="M40.8734 84.8107C41.6455 84.0219 42.9209 84.0082 43.7097 84.7803C44.4986 85.5524 44.5122 86.8278 43.7401 87.6167C42.9586 88.4151 41.6832 88.4288 40.8943 87.6567C40.1149 86.8749 40.1013 85.5995 40.8734 84.8107Z"
                    fill="white" />
                <path
                    d="M33.2249 77.3249C33.9971 76.536 35.2725 76.5224 36.0613 77.2945C36.8501 78.0666 36.8638 79.342 36.0823 80.1405C35.3102 80.9293 34.0347 80.943 33.2459 80.1708C32.4569 79.3797 32.4528 78.1137 33.2249 77.3249Z"
                    fill="white" />
                <path
                    d="M25.5687 69.8296C26.3408 69.0408 27.6162 69.0271 28.4051 69.7992C29.1939 70.5713 29.2076 71.8468 28.426 72.6452C27.6539 73.4341 26.3881 73.4571 25.5897 72.6756C24.8006 71.8845 24.7966 70.6185 25.5687 69.8296Z"
                    fill="white" />
                <path
                    d="M17.9203 62.3439C18.6924 61.5551 19.9582 61.532 20.7566 62.3135C21.5455 63.0856 21.5591 64.361 20.7776 65.1595C20.0055 65.9483 18.7301 65.962 17.9412 65.1899C17.1522 64.3987 17.1481 63.1327 17.9203 62.3439Z"
                    fill="white" />
                <path
                    d="M10.2533 54.8394C11.0254 54.0505 12.3008 54.0369 13.0896 54.809C13.8785 55.5811 13.8921 56.8565 13.1106 57.655C12.3385 58.4438 11.0631 58.4575 10.2742 57.6854C9.49481 56.9036 9.48114 55.6282 10.2533 54.8394Z"
                    fill="white" />
                <path
                    d="M2.59505 47.3441C3.36717 46.5553 4.65221 46.5511 5.44104 47.3232C6.22988 48.0953 6.24355 49.3707 5.46201 50.1692C4.6899 50.958 3.41448 50.9717 2.62564 50.1996C1.8366 49.4084 1.82294 48.133 2.59505 47.3441Z"
                    fill="white" />
                <path
                    d="M48.5192 76.9993C49.3008 76.2008 50.5762 76.1871 51.365 76.9593C52.1539 77.7314 52.1675 79.0068 51.386 79.8053C50.6139 80.5941 49.3385 80.6078 48.5496 79.8356C47.7608 79.0635 47.7471 77.7881 48.5192 76.9993Z"
                    fill="white" />
                <path
                    d="M40.8708 69.5133C41.6523 68.7149 42.9277 68.7012 43.7166 69.4733C44.5054 70.2454 44.5191 71.5208 43.7376 72.3193C42.9654 73.1081 41.69 73.1218 40.9012 72.3497C40.1027 71.5681 40.0987 70.3021 40.8708 69.5133Z"
                    fill="white" />
                <path
                    d="M33.2136 62.0182C33.9951 61.2197 35.2705 61.2061 36.0594 61.9782C36.8482 62.7503 36.8619 64.0257 36.0803 64.8242C35.3082 65.613 34.0424 65.6361 33.244 64.8546C32.4455 64.073 32.4415 62.807 33.2136 62.0182Z"
                    fill="white" />
                <path
                    d="M25.5661 54.5324C26.3476 53.7339 27.6134 53.7108 28.4119 54.4923C29.2007 55.2645 29.2144 56.5399 28.4329 57.3383C27.6607 58.1272 26.3853 58.1408 25.5965 57.3687C24.798 56.5872 24.794 55.3212 25.5661 54.5324Z"
                    fill="white" />
                <path
                    d="M17.8991 47.0278C18.6806 46.2294 19.9561 46.2157 20.7449 46.9878C21.5337 47.7599 21.5474 49.0354 20.7659 49.8338C19.9938 50.6227 18.7183 50.6363 17.9295 49.8642C17.1407 49.0921 17.127 47.8167 17.8991 47.0278Z"
                    fill="white" />
                <path
                    d="M10.2419 39.5327C11.0234 38.7343 12.3085 38.73 13.0973 39.5021C13.8861 40.2742 13.8998 41.5497 13.1183 42.3481C12.3461 43.137 11.0707 43.1506 10.2819 42.3785C9.48344 41.597 9.46977 40.3216 10.2419 39.5327Z"
                    fill="white" />
                <path
                    d="M2.59345 32.0469C3.37498 31.2484 4.6504 31.2348 5.43924 32.0069C6.22808 32.779 6.24174 34.0544 5.46021 34.8529C4.68809 35.6417 3.41268 35.6554 2.62384 34.8832C1.835 34.1111 1.82133 32.8357 2.59345 32.0469Z"
                    fill="white" />
                <path
                    d="M56.1742 69.1783C56.9463 68.3894 58.2217 68.3757 59.0105 69.1479C59.7994 69.92 59.813 71.1954 59.0409 71.9842C58.2688 72.7731 56.9934 72.7867 56.2045 72.0146C55.4157 71.2425 55.3926 69.9767 56.1742 69.1783Z"
                    fill="white" />
                <path
                    d="M48.5267 61.6924C49.2988 60.9036 50.5742 60.8899 51.3631 61.662C52.1519 62.4341 52.1656 63.7096 51.3935 64.4984C50.6213 65.2872 49.3459 65.3009 48.5571 64.5288C47.7586 63.7472 47.7452 62.4909 48.5267 61.6924Z"
                    fill="white" />
                <path
                    d="M40.8695 54.1972C41.6416 53.4083 42.917 53.3947 43.7058 54.1668C44.4947 54.9389 44.5083 56.2143 43.7362 57.0032C42.9641 57.792 41.6983 57.8151 40.8999 57.0335C40.1014 56.252 40.0879 54.9956 40.8695 54.1972Z"
                    fill="white" />
                <path
                    d="M33.221 46.7113C33.9931 45.9225 35.2589 45.8994 36.0574 46.6809C36.8462 47.4531 36.8599 48.7285 36.0878 49.5173C35.3157 50.3062 34.0403 50.3198 33.2514 49.5477C32.453 48.7662 32.4395 47.5098 33.221 46.7113Z"
                    fill="white" />
                <path
                    d="M25.554 39.2069C26.3262 38.4181 27.6016 38.4044 28.3904 39.1766C29.1792 39.9487 29.1929 41.2241 28.4208 42.0129C27.6487 42.8018 26.3733 42.8154 25.5844 42.0433C24.7956 41.2712 24.7725 40.0054 25.554 39.2069Z"
                    fill="white" />
                <path
                    d="M17.8968 31.7117C18.6689 30.9229 19.954 30.9186 20.7428 31.6907C21.5316 32.4628 21.5453 33.7383 20.7732 34.5271C20.0011 35.3159 18.7257 35.3296 17.9368 34.5575C17.1384 33.776 17.1153 32.5102 17.8968 31.7117Z"
                    fill="white" />
                <path
                    d="M10.2484 24.2259C11.0205 23.437 12.2959 23.4234 13.0847 24.1955C13.8736 24.9676 13.8872 26.243 13.1151 27.0318C12.343 27.8207 11.0676 27.8343 10.2788 27.0622C9.48992 26.2901 9.46684 25.0243 10.2484 24.2259Z"
                    fill="white" />
                <path
                    d="M2.59115 16.7307C3.36327 15.9419 4.63868 15.9282 5.43714 16.7098C6.22598 17.4819 6.23964 18.7573 5.46752 19.5461C4.69541 20.335 3.41037 20.3392 2.63115 19.5765C1.83269 18.795 1.80962 17.5292 2.59115 16.7307Z"
                    fill="white" />
                <path
                    d="M63.8197 61.3666C64.5918 60.5778 65.8672 60.5641 66.656 61.3362C67.4449 62.1083 67.4585 63.3837 66.6864 64.1726C65.9049 64.971 64.6389 64.9751 63.85 64.203C63.0612 63.4309 63.0381 62.1651 63.8197 61.3666Z"
                    fill="white" />
                <path
                    d="M56.1722 53.881C56.9443 53.0922 58.2101 53.0691 59.0086 53.8506C59.7974 54.6227 59.8111 55.8982 59.039 56.687C58.2574 57.4855 56.9914 57.4895 56.2026 56.7174C55.4041 55.9358 55.3907 54.6795 56.1722 53.881Z"
                    fill="white" />
                <path
                    d="M48.515 46.3859C49.2871 45.5971 50.5529 45.574 51.3513 46.3555C52.1402 47.1276 52.1538 48.403 51.3817 49.1919C50.6002 49.9903 49.3438 50.0038 48.5454 49.2223C47.7469 48.4407 47.7334 47.1844 48.515 46.3859Z"
                    fill="white" />
                <path
                    d="M40.8665 38.9001C41.6387 38.1112 42.9044 38.0881 43.7029 38.8697C44.4917 39.6418 44.5054 40.9172 43.7333 41.706C42.9518 42.5045 41.6858 42.5085 40.8969 41.7364C40.0985 40.9549 40.085 39.6985 40.8665 38.9001Z"
                    fill="white" />
                <path
                    d="M33.2005 31.3955C33.9726 30.6067 35.2481 30.593 36.0369 31.3652C36.8257 32.1373 36.8394 33.4127 36.0673 34.2015C35.2857 35 34.0197 35.004 33.2309 34.2319C32.4421 33.4598 32.419 32.194 33.2005 31.3955Z"
                    fill="white" />
                <path
                    d="M25.5423 23.9004C26.3144 23.1116 27.5995 23.1073 28.3883 23.8794C29.1771 24.6516 29.1908 25.927 28.4187 26.7158C27.6372 27.5143 26.3712 27.5183 25.5823 26.7462C24.7935 25.9741 24.7608 24.6989 25.5423 23.9004Z"
                    fill="white" />
                <path
                    d="M17.8949 16.4146C18.667 15.6257 19.9424 15.6121 20.7312 16.3842C21.5201 17.1563 21.5337 18.4317 20.7616 19.2206C19.9801 20.019 18.7141 20.0231 17.9252 19.2509C17.1364 18.4788 17.1133 17.213 17.8949 16.4146Z"
                    fill="white" />
                <path
                    d="M10.2367 8.91934C11.0088 8.1305 12.2842 8.11684 13.0826 8.89837C13.8715 9.67049 13.8851 10.9459 13.113 11.7347C12.3315 12.5332 11.0655 12.5372 10.2767 11.7651C9.4782 10.9836 9.45512 9.7178 10.2367 8.91934Z"
                    fill="white" />
                <path
                    d="M2.5892 1.4335C3.36131 0.644661 4.62711 0.621582 5.42557 1.40311C6.2144 2.17523 6.22807 3.45065 5.45595 4.23948C4.67442 5.03794 3.40842 5.04199 2.61958 4.26987C1.82112 3.48834 1.80766 2.23196 2.5892 1.4335Z"
                    fill="white" />
            </svg>

        </div>
        <div class="auth-content ticket-form-wrapper">
            {{-- navbar --}}
            @include('layouts.navbar')

            <div class="row login-row">
                <div class="col-lg-6 col-12">
                    <div class="top-bg">
                        <svg width="66" height="129" viewBox="0 0 66 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M65.4557 123.878C64.6742 123.079 63.4082 123.075 62.6194 123.847C61.8305 124.619 61.8169 125.895 62.589 126.684C63.3705 127.482 64.6365 127.486 65.4253 126.714C66.2142 125.942 66.2373 124.676 65.4557 123.878Z"
                                fill="white"></path>
                            <path
                                d="M57.8095 116.066C57.0374 115.277 55.762 115.264 54.9731 116.036C54.1843 116.808 54.1706 118.083 54.9427 118.872C55.7243 119.671 56.9997 119.684 57.7885 118.912C58.5679 118.13 58.5816 116.855 57.8095 116.066Z"
                                fill="white"></path>
                            <path
                                d="M65.4574 108.58C64.6853 107.791 63.4099 107.777 62.6211 108.549C61.8322 109.322 61.8186 110.597 62.5907 111.386C63.3722 112.184 64.6476 112.198 65.4365 111.426C66.2255 110.635 66.2296 109.369 65.4574 108.58Z"
                                fill="white"></path>
                            <path
                                d="M50.1636 108.255C49.3915 107.466 48.0971 107.452 47.3178 108.215C46.529 108.987 46.5153 110.262 47.2969 111.061C48.069 111.849 49.3444 111.863 50.1332 111.091C50.9221 110.319 50.9357 109.043 50.1636 108.255Z"
                                fill="white"></path>
                            <path
                                d="M57.8113 100.769C57.0392 99.9803 55.7544 99.957 54.9655 100.729C54.1767 101.501 54.163 102.777 54.9446 103.575C55.7167 104.364 56.9921 104.378 57.781 103.606C58.5794 102.824 58.5835 101.558 57.8113 100.769Z"
                                fill="white"></path>
                            <path
                                d="M65.469 93.2741C64.6969 92.4852 63.4121 92.4619 62.6233 93.234C61.8344 94.0062 61.8208 95.2816 62.6023 96.08C63.3744 96.8689 64.6402 96.892 65.4387 96.1104C66.2371 95.3289 66.2412 94.0629 65.469 93.2741Z"
                                fill="white"></path>
                            <path
                                d="M42.5087 100.433C41.7272 99.6349 40.4516 99.6403 39.6723 100.403C38.8835 101.175 38.8698 102.451 39.642 103.239C40.4141 104.028 41.6989 104.051 42.4877 103.279C43.2766 102.507 43.2902 101.232 42.5087 100.433Z"
                                fill="white"></path>
                            <path
                                d="M50.1567 92.948C49.3751 92.1496 48.1091 92.1455 47.3203 92.9176C46.5314 93.6898 46.5178 94.9652 47.2899 95.754C48.062 96.5428 49.3468 96.5661 50.1357 95.794C50.9341 95.0125 50.9382 93.7465 50.1567 92.948Z"
                                fill="white"></path>
                            <path
                                d="M57.8141 85.4529C57.0326 84.6544 55.7666 84.6504 54.9778 85.4225C54.1889 86.1946 54.1753 87.4701 54.9474 88.2589C55.7195 89.0477 56.9947 89.0804 57.7932 88.2989C58.5916 87.5174 58.5957 86.2514 57.8141 85.4529Z"
                                fill="white"></path>
                            <path
                                d="M65.4621 77.9666C64.6805 77.1681 63.4242 77.1547 62.6257 77.9362C61.8369 78.7083 61.8232 79.9837 62.5953 80.7726C63.3674 81.5614 64.6523 81.5847 65.4411 80.8126C66.2396 80.031 66.2436 78.765 65.4621 77.9666Z"
                                fill="white"></path>
                            <path
                                d="M34.8627 92.6219C34.0812 91.8234 32.8056 91.8288 32.0263 92.5915C31.2375 93.3636 31.2238 94.639 31.996 95.4278C32.7681 96.2167 34.0435 96.2303 34.8323 95.4582C35.6212 94.6861 35.6442 93.4203 34.8627 92.6219Z"
                                fill="white"></path>
                            <path
                                d="M42.5104 85.1365C41.7289 84.338 40.4629 84.334 39.674 85.1061C38.8852 85.8782 38.8715 87.1536 39.6437 87.9425C40.4158 88.7313 41.6912 88.745 42.48 87.9729C43.2785 87.1913 43.2919 85.935 42.5104 85.1365Z"
                                fill="white"></path>
                            <path
                                d="M50.1681 77.6414C49.3866 76.8429 48.1206 76.8389 47.3318 77.611C46.5429 78.3831 46.5293 79.6585 47.3014 80.4474C48.0735 81.2362 49.3393 81.2593 50.1377 80.4778C50.9362 79.6962 50.9497 78.4398 50.1681 77.6414Z"
                                fill="white"></path>
                            <path
                                d="M57.8158 70.1551C57.0343 69.3566 55.7779 69.3431 54.9795 70.1247C54.1906 70.8968 54.177 72.1722 54.9491 72.961C55.7212 73.7499 56.9966 73.7635 57.7855 72.9914C58.5839 72.2099 58.5974 70.9535 57.8158 70.1551Z"
                                fill="white"></path>
                            <path
                                d="M65.4833 62.6511C64.7018 61.8527 63.4358 61.8487 62.6469 62.6208C61.8581 63.3929 61.8444 64.6683 62.6166 65.4571C63.3887 66.246 64.6641 66.2596 65.4529 65.4875C66.2418 64.7154 66.2648 63.4496 65.4833 62.6511Z"
                                fill="white"></path>
                            <path
                                d="M27.2172 84.8103C26.4451 84.0215 25.1697 84.0078 24.3808 84.7799C23.592 85.5521 23.5783 86.8275 24.3504 87.6163C25.132 88.4148 26.4074 88.4284 27.1962 87.6563C27.9757 86.8746 27.9893 85.5992 27.2172 84.8103Z"
                                fill="white"></path>
                            <path
                                d="M34.8652 77.325C34.093 76.5361 32.8176 76.5225 32.0288 77.2946C31.2399 78.0667 31.2263 79.3421 32.0078 80.1406C32.7799 80.9294 34.0553 80.9431 34.8442 80.171C35.6332 79.3798 35.6373 78.1138 34.8652 77.325Z"
                                fill="white"></path>
                            <path
                                d="M42.5219 69.8299C41.7498 69.041 40.4744 69.0274 39.6855 69.7995C38.8967 70.5716 38.883 71.847 39.6645 72.6455C40.4367 73.4343 41.7025 73.4574 42.5009 72.6759C43.29 71.8847 43.294 70.6187 42.5219 69.8299Z"
                                fill="white"></path>
                            <path
                                d="M50.1706 62.3435C49.3985 61.5547 48.1327 61.5316 47.3342 62.3131C46.5454 63.0853 46.5317 64.3607 47.3132 65.1591C48.0853 65.948 49.3608 65.9616 50.1496 65.1895C50.9386 64.3984 50.9427 63.1324 50.1706 62.3435Z"
                                fill="white"></path>
                            <path
                                d="M57.8371 54.8396C57.065 54.0508 55.7895 54.0371 55.0007 54.8092C54.2119 55.5814 54.1982 56.8568 54.9797 57.6552C55.7519 58.4441 57.0273 58.4577 57.8161 57.6856C58.5955 56.9039 58.6092 55.6285 57.8371 54.8396Z"
                                fill="white"></path>
                            <path
                                d="M65.4948 47.3445C64.7227 46.5557 63.4376 46.5514 62.6488 47.3235C61.86 48.0957 61.8463 49.3711 62.6278 50.1695C63.3999 50.9584 64.6754 50.972 65.4642 50.1999C66.2532 49.4088 66.2669 48.1333 65.4948 47.3445Z"
                                fill="white"></path>
                            <path
                                d="M19.5711 76.9996C18.7896 76.2012 17.5142 76.1875 16.7253 76.9596C15.9365 77.7317 15.9228 79.0072 16.7043 79.8056C17.4765 80.5945 18.7519 80.6081 19.5407 79.836C20.3296 79.0639 20.3432 77.7885 19.5711 76.9996Z"
                                fill="white"></path>
                            <path
                                d="M27.219 69.5133C26.4375 68.7149 25.1621 68.7012 24.3733 69.4733C23.5844 70.2454 23.5708 71.5208 24.3523 72.3193C25.1244 73.1081 26.3998 73.1218 27.1887 72.3497C27.9871 71.5681 27.9912 70.3021 27.219 69.5133Z"
                                fill="white"></path>
                            <path
                                d="M34.8768 62.0182C34.0952 61.2197 32.8198 61.2061 32.031 61.9782C31.2421 62.7503 31.2285 64.0257 32.01 64.8242C32.7821 65.613 34.0479 65.6361 34.8464 64.8546C35.6448 64.073 35.6489 62.807 34.8768 62.0182Z"
                                fill="white"></path>
                            <path
                                d="M42.5245 54.5319C41.7429 53.7334 40.4771 53.7103 39.6787 54.4919C38.8898 55.264 38.8762 56.5394 39.6577 57.3378C40.4298 58.1267 41.7052 58.1403 42.4941 57.3682C43.2925 56.5867 43.2966 55.3207 42.5245 54.5319Z"
                                fill="white"></path>
                            <path
                                d="M50.1912 47.028C49.4097 46.2295 48.1343 46.2158 47.3454 46.988C46.5566 47.7601 46.5429 49.0355 47.3245 49.8339C48.0966 50.6228 49.372 50.6364 50.1608 49.8643C50.9497 49.0922 50.9633 47.8168 50.1912 47.028Z"
                                fill="white"></path>
                            <path
                                d="M57.8489 39.5328C57.0674 38.7344 55.7824 38.7301 54.9935 39.5023C54.2047 40.2744 54.191 41.5498 54.9726 42.3482C55.7447 43.1371 57.0201 43.1507 57.8089 42.3786C58.6074 41.5971 58.621 40.3217 57.8489 39.5328Z"
                                fill="white"></path>
                            <path
                                d="M65.4966 32.0465C64.7151 31.2481 63.4397 31.2344 62.6509 32.0065C61.862 32.7786 61.8483 34.054 62.6299 34.8525C63.402 35.6413 64.6774 35.655 65.4663 34.8829C66.2551 34.1108 66.2688 32.8354 65.4966 32.0465Z"
                                fill="white"></path>
                            <path
                                d="M11.9157 69.1785C11.1436 68.3897 9.86816 68.376 9.07932 69.1481C8.29048 69.9202 8.27682 71.1956 9.04894 71.9845C9.82105 72.7733 11.0965 72.787 11.8853 72.0149C12.6741 71.2427 12.6972 69.977 11.9157 69.1785Z"
                                fill="white"></path>
                            <path
                                d="M19.5636 61.6922C18.7915 60.9033 17.5161 60.8897 16.7273 61.6618C15.9384 62.4339 15.9248 63.7093 16.6969 64.4982C17.469 65.287 18.7444 65.3007 19.5333 64.5285C20.3317 63.747 20.3452 62.4906 19.5636 61.6922Z"
                                fill="white"></path>
                            <path
                                d="M27.2211 54.197C26.449 53.4082 25.1736 53.3945 24.3847 54.1667C23.5959 54.9388 23.5822 56.2142 24.3544 57.003C25.1265 57.7919 26.3923 57.815 27.1907 57.0334C27.9892 56.2519 28.0026 54.9955 27.2211 54.197Z"
                                fill="white"></path>
                            <path
                                d="M34.8691 46.7117C34.0969 45.9229 32.8311 45.8998 32.0327 46.6813C31.2438 47.4534 31.2302 48.7288 32.0023 49.5177C32.7744 50.3065 34.0498 50.3202 34.8387 49.5481C35.6371 48.7665 35.6506 47.5102 34.8691 46.7117Z"
                                fill="white"></path>
                            <path
                                d="M42.5363 39.2068C41.7642 38.418 40.4888 38.4043 39.6999 39.1764C38.9111 39.9485 38.8974 41.224 39.6695 42.0128C40.4417 42.8016 41.7171 42.8153 42.5059 42.0432C43.2947 41.2711 43.3178 40.0053 42.5363 39.2068Z"
                                fill="white"></path>
                            <path
                                d="M50.194 31.7117C49.4219 30.9229 48.1369 30.9186 47.348 31.6907C46.5592 32.4628 46.5455 33.7383 47.3176 34.5271C48.0897 35.3159 49.3652 35.3296 50.154 34.5575C50.9525 33.776 50.9755 32.5102 50.194 31.7117Z"
                                fill="white"></path>
                            <path
                                d="M57.8417 24.2263C57.0696 23.4375 55.7942 23.4238 55.0053 24.196C54.2165 24.9681 54.2028 26.2435 54.975 27.0323C55.7471 27.8212 57.0225 27.8348 57.8113 27.0627C58.6002 26.2906 58.6232 25.0248 57.8417 24.2263Z"
                                fill="white"></path>
                            <path
                                d="M65.4994 16.7312C64.7273 15.9424 63.4519 15.9287 62.6534 16.7103C61.8646 17.4824 61.8509 18.7578 62.6231 19.5466C63.3952 20.3355 64.6802 20.3397 65.4594 19.577C66.2579 18.7955 66.281 17.5297 65.4994 16.7312Z"
                                fill="white"></path>
                            <path
                                d="M4.27018 61.367C3.49806 60.5781 2.22265 60.5645 1.43381 61.3366C0.644973 62.1087 0.631312 63.3841 1.40343 64.173C2.18496 64.9714 3.45096 64.9755 4.2398 64.2033C5.02863 63.4312 5.05171 62.1654 4.27018 61.367Z"
                                fill="white"></path>
                            <path
                                d="M11.9181 53.8806C11.146 53.0918 9.88022 53.0687 9.08176 53.8503C8.29292 54.6224 8.27926 55.8978 9.05137 56.6866C9.83291 57.4851 11.0989 57.4891 11.8877 56.717C12.6862 55.9355 12.6997 54.6791 11.9181 53.8806Z"
                                fill="white"></path>
                            <path
                                d="M19.5751 46.3855C18.803 45.5967 17.5372 45.5736 16.7387 46.3551C15.9499 47.1273 15.9362 48.4027 16.7084 49.1915C17.4899 49.99 18.7463 50.0034 19.5447 49.2219C20.3432 48.4404 20.3566 47.184 19.5751 46.3855Z"
                                fill="white"></path>
                            <path
                                d="M27.2235 38.9002C26.4514 38.1113 25.1856 38.0883 24.3872 38.8698C23.5983 39.6419 23.5847 40.9173 24.3568 41.7062C25.1383 42.5046 26.4043 42.5087 27.1932 41.7365C27.9916 40.955 28.0051 39.6986 27.2235 38.9002Z"
                                fill="white"></path>
                            <path
                                d="M34.8903 31.3953C34.1182 30.6065 32.8428 30.5928 32.0539 31.3649C31.2651 32.137 31.2514 33.4124 32.0235 34.2013C32.8051 34.9997 34.0711 35.0038 34.8599 34.2317C35.6487 33.4595 35.6718 32.1938 34.8903 31.3953Z"
                                fill="white"></path>
                            <path
                                d="M42.5478 23.9002C41.7757 23.1113 40.4906 23.1071 39.7018 23.8792C38.9129 24.6513 38.8993 25.9267 39.6714 26.7156C40.4529 27.514 41.7189 27.5181 42.5078 26.746C43.2966 25.9738 43.3293 24.6986 42.5478 23.9002Z"
                                fill="white"></path>
                            <path
                                d="M50.1957 16.4148C49.4236 15.626 48.1482 15.6123 47.3593 16.3844C46.5705 17.1566 46.5568 18.432 47.329 19.2208C48.1105 20.0193 49.3765 20.0233 50.1653 19.2512C50.9542 18.4791 50.9772 17.2133 50.1957 16.4148Z"
                                fill="white"></path>
                            <path
                                d="M57.8534 8.91971C57.0813 8.13087 55.8059 8.1172 55.0074 8.89874C54.2186 9.67085 54.2049 10.9463 54.9771 11.7351C55.7586 12.5336 57.0246 12.5376 57.8134 11.7655C58.6119 10.984 58.635 9.71816 57.8534 8.91971Z"
                                fill="white"></path>
                            <path
                                d="M65.5011 1.43338C64.729 0.644539 63.4632 0.62146 62.6648 1.40299C61.8759 2.17511 61.8623 3.45052 62.6344 4.23936C63.4159 5.03782 64.6819 5.04186 65.4708 4.26975C66.2692 3.48822 66.2827 2.23184 65.5011 1.43338Z"
                                fill="white"></path>
                        </svg>
                    </div>
                    <div class="login-img">
                    <svg width="752" height="752" viewBox="0 0 752 752" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="376" cy="376" r="376" fill="white" fill-opacity="0.1"/>
<circle cx="375.93" cy="375.93" r="331.93" fill="white" fill-opacity="0.1"/>
<path d="M308.525 654.863C370.623 654.863 420.963 625.8 420.963 589.948C420.963 554.097 370.623 525.033 308.525 525.033C246.428 525.033 196.088 554.097 196.088 589.948C196.088 625.8 246.428 654.863 308.525 654.863Z" fill="white" fill-opacity="0.2"/>
<path d="M446.804 467.687L441.553 464.652C439.899 463.696 438.558 461.372 438.558 459.461L438.557 241.457C438.557 239.546 439.898 237.222 441.553 236.267L587.35 152.092C589.006 151.137 591.688 151.137 593.343 152.092L598.595 155.123C600.251 156.078 601.592 158.402 601.592 160.313V378.315C601.592 380.227 600.251 382.55 598.595 383.505L452.795 467.687C451.141 468.643 448.458 468.642 446.804 467.687Z" fill="#455A64"/>
<path d="M601.567 159.826C601.36 158.276 600.1 157.708 598.592 158.58L452.801 242.769C451.971 243.253 451.237 244.056 450.684 244.997L439.432 238.506C439.971 237.565 440.719 236.749 441.549 236.264L587.354 152.089C589.001 151.134 591.685 151.134 593.346 152.089L598.592 155.12C600.114 155.992 601.373 158.027 601.567 159.826Z" fill="#455A64"/>
<path d="M452.289 467.928C450.628 468.634 448.303 468.551 446.808 467.693L441.549 464.648C439.902 463.693 438.56 461.368 438.56 459.458V241.454C438.56 240.499 438.892 239.447 439.431 238.506L450.683 244.997C450.13 245.938 449.798 247.004 449.798 247.959V465.963C449.798 467.679 450.877 468.468 452.289 467.928Z" fill="#263238"/>
<path d="M449.799 247.956V465.958C449.799 467.87 451.14 468.643 452.795 467.688L598.595 383.507C600.251 382.552 601.592 380.228 601.592 378.317V160.312C601.592 158.4 600.251 157.627 598.595 158.582L452.795 242.766C451.141 243.721 449.799 246.045 449.799 247.956Z" fill="#37474F"/>
<path d="M415.751 331.054C413.869 329.933 405.136 324.965 404.679 324.702C403.295 323.858 402.797 321.809 404.084 320.425L438.559 283.445L449.798 289.894L415.336 326.889C414.09 328.217 414.492 330.141 415.751 331.054Z" fill="#455A64"/>
<path d="M449.8 289.9L415.332 326.884C413.604 328.738 415.063 331.745 417.588 331.537L449.8 328.884V289.9Z" fill="#37474F"/>
<path d="M525.694 223.352C542.687 213.54 556.462 221.494 556.462 241.115C556.462 260.736 542.687 284.595 525.694 294.406C508.702 304.217 494.927 296.263 494.927 276.642C494.928 257.02 508.703 233.161 525.694 223.352Z" fill="#FFA21D"/>
<path d="M525.478 238.793C530.991 235.61 535.461 238.189 535.461 244.554C535.461 250.921 530.992 258.662 525.478 261.843C519.966 265.025 515.497 262.447 515.497 256.08C515.497 249.715 519.966 241.975 525.478 238.793Z" fill="white"/>
<path d="M545.15 272.735C545.15 262.277 537.807 258.037 528.751 263.267L523.089 266.536C514.034 271.765 506.69 284.483 506.69 294.94V297.793C508.326 298.335 510.101 298.604 511.977 298.608C516.109 298.616 520.759 297.256 525.696 294.406C533.078 290.143 539.85 283.226 545.15 275.162V272.735Z" fill="white"/>
<path class="theme-color" d="M506.205 391.546L545.187 369.04C546.842 368.085 548.183 368.858 548.183 370.77V383.324C548.183 385.235 546.842 387.559 545.187 388.514L506.205 411.021C504.55 411.976 503.209 411.202 503.209 409.291V396.736C503.209 394.825 504.55 392.501 506.205 391.546Z" fill="#0CAF60"/>
<path d="M487.126 363.501L564.264 318.967C566.25 317.821 567.859 318.749 567.859 321.043V325.715C567.859 328.008 566.25 330.797 564.264 331.943L487.128 376.477C485.142 377.623 483.532 376.695 483.532 374.401V369.729C483.531 367.436 485.142 364.647 487.126 363.501Z" fill="#FAFAFA"/>
<path d="M496.148 331.27C497.197 330.664 498.013 330.573 498.595 331C499.176 331.427 499.466 332.373 499.466 333.843C499.466 335.314 499.176 336.603 498.595 337.713C498.013 338.824 497.197 339.682 496.148 340.288L494.065 341.49V345.959C494.065 346.107 494.03 346.252 493.961 346.399C493.89 346.547 493.809 346.648 493.712 346.702L492.659 347.311C492.563 347.368 492.48 347.362 492.409 347.294C492.34 347.226 492.306 347.121 492.306 346.973V334.027C492.306 333.881 492.34 333.732 492.409 333.586C492.48 333.44 492.562 333.337 492.659 333.283L496.148 331.27ZM494.065 338.985L496.081 337.819C496.575 337.534 496.971 337.156 497.266 336.685C497.561 336.214 497.707 335.606 497.707 334.858C497.707 334.109 497.561 333.676 497.266 333.559C496.97 333.443 496.575 333.528 496.081 333.814L494.065 334.978V338.985Z" fill="#FAFAFA"/>
<path d="M505.271 326.001C505.41 325.921 505.515 325.917 505.584 325.99C505.655 326.065 505.716 326.199 505.767 326.397L508.957 337.221C508.965 337.256 508.969 337.3 508.969 337.354C508.969 337.501 508.935 337.648 508.866 337.794C508.796 337.941 508.715 338.044 508.618 338.098L507.681 338.639C507.508 338.738 507.385 338.752 507.315 338.679C507.245 338.605 507.199 338.524 507.172 338.43L506.612 336.529L502.499 338.906L501.94 341.452C501.914 341.574 501.865 341.713 501.797 341.866C501.727 342.02 501.606 342.146 501.432 342.247L500.495 342.788C500.4 342.842 500.317 342.836 500.247 342.769C500.177 342.702 500.144 342.596 500.144 342.45C500.144 342.396 500.148 342.348 500.157 342.302L503.346 327.796C503.399 327.538 503.458 327.334 503.529 327.181C503.598 327.028 503.702 326.911 503.842 326.83L505.271 326.001ZM505.987 334.387L504.556 329.503L503.125 336.04L505.987 334.387Z" fill="#FAFAFA"/>
<path d="M513.81 320.871C514.392 320.536 514.904 320.36 515.345 320.346C515.788 320.33 516.156 320.418 516.452 320.608C516.747 320.799 516.97 321.067 517.122 321.413C517.273 321.759 517.359 322.122 517.377 322.498C517.385 322.653 517.352 322.803 517.28 322.945C517.205 323.087 517.121 323.186 517.025 323.242L516.113 323.768C515.967 323.855 515.857 323.873 515.782 323.83C515.709 323.787 515.64 323.708 515.58 323.597C515.45 323.337 515.255 323.161 514.989 323.066C514.724 322.973 514.331 323.074 513.81 323.376C513.585 323.506 513.37 323.668 513.167 323.858C512.962 324.05 512.783 324.259 512.632 324.487C512.48 324.714 512.361 324.955 512.274 325.204C512.187 325.456 512.144 325.708 512.144 325.961C512.144 326.27 512.184 326.497 512.267 326.642C512.349 326.787 512.487 326.875 512.684 326.902C512.879 326.931 513.138 326.911 513.459 326.846C513.78 326.781 514.18 326.692 514.656 326.576C515.176 326.448 515.625 326.394 516.004 326.411C516.38 326.428 516.688 326.529 516.927 326.718C517.166 326.909 517.344 327.183 517.461 327.543C517.579 327.904 517.637 328.357 517.637 328.904C517.637 329.506 517.55 330.113 517.377 330.728C517.204 331.341 516.955 331.925 516.635 332.478C516.312 333.031 515.919 333.55 515.449 334.034C514.981 334.518 514.455 334.928 513.874 335.264C513.387 335.545 512.923 335.724 512.482 335.797C512.039 335.873 511.646 335.84 511.304 335.698C510.961 335.554 510.685 335.303 510.475 334.942C510.269 334.581 510.151 334.114 510.125 333.541C510.115 333.386 510.15 333.237 510.221 333.094C510.295 332.953 510.379 332.854 510.475 332.798L511.387 332.272C511.534 332.185 511.647 332.162 511.725 332.196C511.803 332.231 511.867 332.314 511.921 332.442C511.982 332.584 512.055 332.714 512.142 332.837C512.23 332.96 512.345 333.046 512.493 333.094C512.639 333.143 512.825 333.146 513.046 333.107C513.268 333.065 513.542 332.95 513.872 332.758C514.133 332.61 514.385 332.434 514.628 332.232C514.87 332.033 515.084 331.809 515.266 331.564C515.448 331.319 515.594 331.061 515.708 330.787C515.82 330.515 515.877 330.225 515.877 329.917C515.877 329.625 515.816 329.42 515.695 329.302C515.573 329.185 515.388 329.132 515.142 329.142C514.894 329.15 514.589 329.2 514.224 329.29C513.86 329.378 513.439 329.47 512.962 329.557C512.527 329.647 512.148 329.676 511.823 329.644C511.498 329.612 511.228 329.496 511.016 329.298C510.804 329.1 510.645 328.814 510.541 328.44C510.437 328.065 510.386 327.579 510.386 326.976C510.386 326.375 510.473 325.77 510.646 325.164C510.819 324.556 511.059 323.982 511.363 323.448C511.666 322.911 512.028 322.418 512.45 321.97C512.87 321.517 513.326 321.152 513.81 320.871Z" fill="#FAFAFA"/>
<path d="M522.894 315.627C523.477 315.292 523.988 315.116 524.429 315.101C524.872 315.086 525.242 315.173 525.538 315.363C525.831 315.554 526.054 315.822 526.206 316.168C526.359 316.516 526.443 316.878 526.461 317.253C526.469 317.41 526.437 317.559 526.364 317.7C526.289 317.843 526.205 317.942 526.109 317.996L525.197 318.524C525.049 318.61 524.94 318.629 524.867 318.586C524.793 318.542 524.725 318.463 524.666 318.352C524.534 318.095 524.339 317.916 524.074 317.821C523.809 317.728 523.416 317.829 522.894 318.131C522.669 318.262 522.456 318.423 522.251 318.614C522.046 318.806 521.869 319.014 521.717 319.242C521.564 319.47 521.445 319.71 521.358 319.96C521.271 320.211 521.228 320.463 521.228 320.717C521.228 321.026 521.268 321.252 521.351 321.397C521.434 321.545 521.571 321.631 521.768 321.658C521.964 321.686 522.222 321.667 522.543 321.602C522.864 321.537 523.264 321.448 523.74 321.332C524.262 321.205 524.709 321.151 525.088 321.166C525.464 321.182 525.773 321.283 526.011 321.473C526.251 321.665 526.429 321.938 526.545 322.298C526.663 322.66 526.721 323.112 526.721 323.66C526.721 324.26 526.634 324.868 526.461 325.484C526.288 326.097 526.039 326.681 525.719 327.233C525.399 327.787 525.004 328.304 524.534 328.79C524.067 329.275 523.541 329.684 522.961 330.019C522.472 330.3 522.009 330.479 521.567 330.553C521.126 330.63 520.733 330.595 520.389 330.452C520.046 330.31 519.771 330.059 519.562 329.697C519.354 329.336 519.237 328.869 519.21 328.296C519.202 328.141 519.235 327.992 519.308 327.85C519.38 327.707 519.465 327.608 519.562 327.553L520.472 327.027C520.619 326.941 520.733 326.916 520.81 326.952C520.89 326.987 520.954 327.069 521.007 327.199C521.068 327.338 521.142 327.468 521.228 327.593C521.315 327.715 521.432 327.801 521.58 327.85C521.726 327.899 521.912 327.902 522.132 327.863C522.353 327.821 522.627 327.707 522.959 327.516C523.22 327.366 523.47 327.192 523.714 326.988C523.956 326.79 524.169 326.566 524.352 326.321C524.533 326.075 524.681 325.819 524.795 325.545C524.907 325.273 524.962 324.984 524.962 324.676C524.962 324.382 524.901 324.177 524.781 324.06C524.659 323.943 524.474 323.889 524.227 323.899C523.981 323.909 523.675 323.957 523.31 324.047C522.946 324.137 522.525 324.227 522.047 324.316C521.614 324.404 521.234 324.435 520.908 324.403C520.585 324.37 520.313 324.255 520.103 324.057C519.89 323.859 519.731 323.573 519.627 323.197C519.523 322.824 519.472 322.337 519.472 321.735C519.472 321.134 519.559 320.529 519.732 319.922C519.905 319.314 520.144 318.741 520.449 318.205C520.752 317.668 521.113 317.177 521.535 316.727C521.956 316.273 522.409 315.908 522.894 315.627Z" fill="#FAFAFA"/>
<path d="M532.983 317.358L531.863 323.996C531.82 324.22 531.765 324.417 531.7 324.58C531.635 324.745 531.538 324.865 531.408 324.94L530.352 325.549C530.222 325.624 530.119 325.621 530.046 325.534C529.971 325.449 529.923 325.315 529.898 325.131L528.23 313.448C528.222 313.386 528.218 313.335 528.218 313.296C528.218 313.15 528.252 313.001 528.322 312.855C528.391 312.708 528.472 312.606 528.569 312.552L529.531 311.995C529.618 311.947 529.701 311.939 529.78 311.973C529.858 312.008 529.91 312.117 529.935 312.304L531.029 320.169L531.992 314.262C532.01 314.159 532.05 314.013 532.116 313.829C532.18 313.645 532.291 313.508 532.447 313.417L533.514 312.801C533.671 312.711 533.781 312.721 533.846 312.83C533.912 312.939 533.952 313.035 533.97 313.118L534.933 317.913L536.026 308.786C536.051 308.57 536.105 308.401 536.183 308.274C536.26 308.149 536.343 308.061 536.43 308.012L537.392 307.456C537.488 307.402 537.571 307.407 537.64 307.475C537.709 307.542 537.744 307.648 537.744 307.795C537.744 307.834 537.74 307.89 537.731 307.961L536.065 321.568C536.037 321.784 535.989 321.977 535.917 322.146C535.842 322.314 535.741 322.438 535.61 322.514L534.555 323.121C534.424 323.197 534.327 323.19 534.262 323.101C534.197 323.011 534.143 322.879 534.098 322.703L532.983 317.358Z" fill="#FAFAFA"/>
<path d="M539.464 311.492C539.491 310.729 539.583 309.969 539.743 309.215C539.904 308.461 540.141 307.749 540.453 307.082C540.766 306.415 541.156 305.801 541.624 305.244C542.095 304.685 542.648 304.223 543.292 303.851C543.924 303.484 544.475 303.307 544.943 303.316C545.412 303.327 545.802 303.489 546.115 303.803C546.428 304.118 546.665 304.555 546.831 305.113C546.996 305.673 547.092 306.325 547.119 307.071C547.127 307.322 547.134 307.598 547.138 307.901C547.142 308.206 547.145 308.522 547.145 308.85C547.145 309.178 547.142 309.496 547.138 309.804C547.134 310.116 547.127 310.4 547.119 310.657C547.091 311.422 546.998 312.179 546.839 312.934C546.679 313.688 546.442 314.399 546.129 315.066C545.816 315.734 545.423 316.345 544.951 316.899C544.477 317.452 543.924 317.912 543.292 318.277C542.648 318.648 542.095 318.828 541.624 318.82C541.156 318.809 540.766 318.651 540.453 318.342C540.141 318.037 539.904 317.599 539.743 317.029C539.583 316.462 539.49 315.81 539.464 315.078C539.455 314.828 539.447 314.553 539.444 314.246C539.439 313.941 539.438 313.626 539.438 313.299C539.438 312.972 539.439 312.653 539.444 312.343C539.449 312.034 539.455 311.75 539.464 311.492ZM545.361 308.187C545.326 307.244 545.124 306.617 544.755 306.302C544.385 305.987 543.898 306.004 543.291 306.356C542.683 306.707 542.194 307.252 541.825 307.994C541.455 308.735 541.253 309.594 541.219 310.577C541.201 311.094 541.191 311.665 541.191 312.286C541.191 312.907 541.201 313.465 541.219 313.963C541.252 314.906 541.455 315.53 541.825 315.837C542.194 316.146 542.682 316.124 543.291 315.774C543.898 315.424 544.385 314.881 544.755 314.147C545.124 313.413 545.325 312.556 545.361 311.573C545.379 311.056 545.387 310.487 545.387 309.865C545.387 309.244 545.379 308.686 545.361 308.187Z" fill="#FAFAFA"/>
<path d="M553.196 298.332C554.28 297.707 555.103 297.618 555.668 298.068C556.231 298.518 556.514 299.43 556.514 300.807C556.514 301.783 556.37 302.696 556.079 303.553C555.787 304.408 555.359 305.167 554.796 305.827L556.593 309.739C556.619 309.804 556.631 309.871 556.631 309.939C556.631 310.058 556.602 310.177 556.546 310.298C556.49 310.418 556.421 310.499 556.343 310.545L555.236 311.183C555.063 311.283 554.935 311.294 554.853 311.215C554.77 311.133 554.712 311.053 554.677 310.966L552.973 307.279L551.242 308.279V312.949C551.242 313.096 551.207 313.242 551.138 313.388C551.068 313.536 550.987 313.637 550.891 313.693L549.836 314.301C549.74 314.355 549.659 314.349 549.588 314.282C549.518 314.215 549.484 314.11 549.484 313.963V301.017C549.484 300.869 549.518 300.723 549.588 300.577C549.659 300.429 549.739 300.328 549.836 300.271L553.196 298.332ZM551.243 305.773L553.13 304.684C553.625 304.398 554.02 304.036 554.315 303.599C554.609 303.163 554.756 302.569 554.756 301.82C554.756 301.073 554.608 300.656 554.315 300.573C554.018 300.49 553.625 300.591 553.13 300.878L551.243 301.967V305.773Z" fill="#FAFAFA"/>
<path d="M562.424 293.004C563.067 292.633 563.623 292.442 564.096 292.428C564.57 292.417 564.964 292.56 565.282 292.859C565.599 293.156 565.84 293.596 566.01 294.18C566.179 294.765 566.28 295.468 566.316 296.288C566.351 297.256 566.351 298.245 566.316 299.254C566.282 300.116 566.179 300.937 566.01 301.715C565.84 302.496 565.601 303.214 565.288 303.877C564.974 304.538 564.586 305.132 564.121 305.661C563.658 306.191 563.114 306.634 562.488 306.995L559.208 308.888C559.112 308.944 559.031 308.938 558.96 308.87C558.891 308.804 558.856 308.699 558.856 308.551V295.605C558.856 295.459 558.891 295.31 558.96 295.164C559.031 295.018 559.111 294.915 559.208 294.86L562.424 293.004ZM564.559 297.303C564.541 296.886 564.487 296.519 564.397 296.205C564.305 295.891 564.171 295.648 563.992 295.477C563.814 295.306 563.591 295.223 563.324 295.223C563.054 295.225 562.732 295.333 562.361 295.549L560.617 296.555V305.574L562.426 304.53C562.781 304.325 563.089 304.071 563.35 303.765C563.61 303.462 563.826 303.127 564.001 302.757C564.174 302.389 564.307 301.993 564.398 301.567C564.488 301.139 564.543 300.707 564.56 300.271C564.592 299.26 564.592 298.273 564.559 297.303Z" fill="#FAFAFA"/>
<path d="M372.369 92.1386C374.789 92.6742 377.068 93.5309 379.209 94.7059C381.35 95.8823 383.165 97.3231 384.65 99.0282C386.135 100.732 387.205 102.669 387.856 104.84C388.51 107.007 388.557 109.354 387.999 111.874C387.544 113.932 386.825 115.651 385.847 117.026C384.866 118.401 383.74 119.583 382.47 120.569C381.199 121.556 379.858 122.421 378.455 123.161C377.047 123.903 375.716 124.607 374.465 125.272C373.21 125.939 372.073 126.675 371.062 127.475C370.047 128.276 369.339 129.227 368.933 130.325C368.703 130.868 368.364 131.304 367.914 131.635C367.462 131.969 366.954 132.07 366.388 131.947L360.521 130.647C359.955 130.522 359.498 130.207 359.154 129.696C358.808 129.188 358.723 128.658 358.899 128.103C359.447 126.119 360.259 124.449 361.343 123.097C362.425 121.745 363.627 120.581 364.95 119.604C366.273 118.628 367.647 117.787 369.073 117.077C370.497 116.366 371.824 115.675 373.055 115.002C374.282 114.331 375.331 113.617 376.198 112.865C377.067 112.114 377.62 111.196 377.86 110.115C378.293 108.161 377.827 106.37 376.458 104.744C375.09 103.119 373.042 102.005 370.316 101.4C365.942 100.432 362.241 101.907 359.215 105.825C358.833 106.334 358.467 106.698 358.124 106.918C357.777 107.14 357.269 107.176 356.599 107.026L350.347 105.642C349.885 105.54 349.518 105.296 349.254 104.914C348.988 104.532 348.912 104.083 349.026 103.568C349.474 101.778 350.437 100.062 351.907 98.4165C353.377 96.7723 355.169 95.3883 357.28 94.2617C359.392 93.1379 361.753 92.3504 364.362 91.9033C366.975 91.4577 369.642 91.5338 372.369 92.1386ZM365.75 136.665C366.314 136.789 366.759 137.103 367.077 137.607C367.398 138.11 367.496 138.644 367.37 139.21L365.866 146.001C365.74 146.569 365.427 147.011 364.924 147.331C364.421 147.654 363.888 147.751 363.322 147.625L356.685 146.155C356.117 146.027 355.674 145.716 355.353 145.211C355.032 144.708 354.934 144.176 355.06 143.608L356.564 136.816C356.69 136.251 357.003 135.807 357.507 135.486C358.01 135.167 358.543 135.068 359.111 135.193L365.75 136.665Z" fill="#EB996E"/>
<path d="M379.759 157.062C381.446 156.787 383.127 156.749 384.802 156.957C386.475 157.162 388.006 157.62 389.395 158.333C390.784 159.048 391.966 160.016 392.939 161.239C393.914 162.464 394.544 163.956 394.832 165.712C395.066 167.149 395.045 168.436 394.77 169.567C394.494 170.699 394.075 171.745 393.513 172.704C392.951 173.662 392.314 174.559 391.602 175.393C390.89 176.229 390.218 177.019 389.585 177.768C388.951 178.517 388.411 179.279 387.967 180.052C387.522 180.824 387.31 181.614 387.332 182.421C387.324 182.829 387.217 183.196 387.015 183.524C386.81 183.852 386.51 184.049 386.117 184.114L382.023 184.782C381.627 184.847 381.253 184.76 380.9 184.522C380.549 184.285 380.358 183.967 380.33 183.566C380.174 182.153 380.268 180.877 380.617 179.731C380.963 178.587 381.436 177.531 382.034 176.568C382.632 175.605 383.298 174.712 384.03 173.892C384.762 173.072 385.436 172.289 386.052 171.542C386.666 170.798 387.156 170.072 387.52 169.369C387.884 168.663 388.006 167.935 387.883 167.179C387.66 165.817 386.901 164.788 385.607 164.094C384.313 163.402 382.716 163.211 380.813 163.523C377.762 164.021 375.767 165.916 374.829 169.203C374.714 169.626 374.574 169.953 374.408 170.182C374.243 170.414 373.926 170.566 373.46 170.642L369.099 171.356C368.775 171.409 368.479 171.346 368.209 171.169C367.941 170.991 367.777 170.724 367.718 170.364C367.548 169.103 367.725 167.755 368.248 166.324C368.768 164.893 369.563 163.546 370.628 162.285C371.694 161.023 373.007 159.916 374.564 158.961C376.126 158.006 377.856 157.374 379.759 157.062ZM386.911 187.301C387.306 187.237 387.671 187.326 388.006 187.564C388.339 187.806 388.539 188.123 388.604 188.516L389.379 193.258C389.444 193.652 389.355 194.018 389.116 194.351C388.875 194.686 388.558 194.884 388.162 194.949L383.53 195.706C383.136 195.771 382.77 195.684 382.437 195.445C382.102 195.204 381.902 194.887 381.837 194.492L381.062 189.751C380.999 189.358 381.086 188.992 381.325 188.657C381.566 188.324 381.883 188.123 382.278 188.058L386.911 187.301Z" fill="#FFA21D"/>
<g opacity="0.2">
<path d="M379.759 157.062C381.446 156.787 383.127 156.749 384.802 156.957C386.475 157.162 388.006 157.62 389.395 158.333C390.784 159.048 391.966 160.016 392.939 161.239C393.914 162.464 394.544 163.956 394.832 165.712C395.066 167.149 395.045 168.436 394.77 169.567C394.494 170.699 394.075 171.745 393.513 172.704C392.951 173.662 392.314 174.559 391.602 175.393C390.89 176.229 390.218 177.019 389.585 177.768C388.951 178.517 388.411 179.279 387.967 180.052C387.522 180.824 387.31 181.614 387.332 182.421C387.324 182.829 387.217 183.196 387.015 183.524C386.81 183.852 386.51 184.049 386.117 184.114L382.023 184.782C381.627 184.847 381.253 184.76 380.9 184.522C380.549 184.285 380.358 183.967 380.33 183.566C380.174 182.153 380.268 180.877 380.617 179.731C380.963 178.587 381.436 177.531 382.034 176.568C382.632 175.605 383.298 174.712 384.03 173.892C384.762 173.072 385.436 172.289 386.052 171.542C386.666 170.798 387.156 170.072 387.52 169.369C387.884 168.663 388.006 167.935 387.883 167.179C387.66 165.817 386.901 164.788 385.607 164.094C384.313 163.402 382.716 163.211 380.813 163.523C377.762 164.021 375.767 165.916 374.829 169.203C374.714 169.626 374.574 169.953 374.408 170.182C374.243 170.414 373.926 170.566 373.46 170.642L369.099 171.356C368.775 171.409 368.479 171.346 368.209 171.169C367.941 170.991 367.777 170.724 367.718 170.364C367.548 169.103 367.725 167.755 368.248 166.324C368.768 164.893 369.563 163.546 370.628 162.285C371.694 161.023 373.007 159.916 374.564 158.961C376.126 158.006 377.856 157.374 379.759 157.062ZM386.911 187.301C387.306 187.237 387.671 187.326 388.006 187.564C388.339 187.806 388.539 188.123 388.604 188.516L389.379 193.258C389.444 193.652 389.355 194.018 389.116 194.351C388.875 194.686 388.558 194.884 388.162 194.949L383.53 195.706C383.136 195.771 382.77 195.684 382.437 195.445C382.102 195.204 381.902 194.887 381.837 194.492L381.062 189.751C380.999 189.358 381.086 188.992 381.325 188.657C381.566 188.324 381.883 188.123 382.278 188.058L386.911 187.301Z" fill="black"/>
</g>
<path d="M418.892 164.513C419.278 164.789 419.512 165.167 419.595 165.647C419.675 166.129 419.578 166.562 419.304 166.948L416.007 171.586C415.732 171.973 415.354 172.207 414.874 172.287C414.392 172.37 413.959 172.272 413.573 171.998L409.042 168.776C408.654 168.501 408.422 168.124 408.34 167.644C408.257 167.161 408.355 166.729 408.631 166.343L411.927 161.704C412.201 161.318 412.578 161.084 413.061 161.002C413.541 160.921 413.973 161.017 414.361 161.293L418.892 164.513ZM438.066 133.08C439.715 134.252 441.162 135.624 442.4 137.192C443.639 138.761 444.548 140.424 445.121 142.18C445.697 143.939 445.885 145.737 445.686 147.579C445.487 149.422 444.777 151.204 443.552 152.925C442.553 154.331 441.465 155.396 440.291 156.12C439.115 156.845 437.891 157.376 436.619 157.714C435.346 158.053 434.062 158.277 432.769 158.389C431.471 158.499 430.246 158.605 429.089 158.708C427.932 158.81 426.843 159.002 425.826 159.283C424.806 159.563 423.968 160.054 423.315 160.752C422.969 161.088 422.575 161.308 422.129 161.415C421.683 161.521 421.268 161.437 420.882 161.161L416.875 158.313C416.489 158.039 416.245 157.656 416.147 157.162C416.049 156.669 416.153 156.241 416.463 155.879C417.509 154.558 418.652 153.56 419.899 152.886C421.145 152.214 422.421 151.718 423.73 151.404C425.035 151.09 426.34 150.894 427.641 150.813C428.94 150.732 430.16 150.633 431.302 150.518C432.441 150.404 433.457 150.202 434.352 149.911C435.245 149.62 435.955 149.107 436.48 148.369C437.429 147.034 437.646 145.537 437.134 143.877C436.622 142.217 435.435 140.725 433.575 139.402C430.587 137.279 427.327 137.211 423.799 139.199C423.348 139.46 422.958 139.621 422.629 139.676C422.296 139.732 421.905 139.597 421.448 139.273L417.178 136.238C416.863 136.014 416.665 135.715 416.586 135.343C416.507 134.968 416.594 134.608 416.842 134.256C417.75 133.051 419.02 132.063 420.654 131.292C422.287 130.521 424.076 130.049 426.026 129.875C427.974 129.7 430.002 129.858 432.11 130.354C434.215 130.846 436.201 131.756 438.066 133.08Z" fill="#FFA21D"/>
<g opacity="0.6">
<path d="M418.892 164.513C419.278 164.789 419.512 165.167 419.595 165.647C419.675 166.129 419.578 166.562 419.304 166.948L416.007 171.586C415.732 171.973 415.354 172.207 414.874 172.287C414.392 172.37 413.959 172.272 413.573 171.998L409.042 168.776C408.654 168.501 408.422 168.124 408.34 167.644C408.257 167.161 408.355 166.729 408.631 166.343L411.927 161.704C412.201 161.318 412.578 161.084 413.061 161.002C413.541 160.921 413.973 161.017 414.361 161.293L418.892 164.513ZM438.066 133.08C439.715 134.252 441.162 135.624 442.4 137.192C443.639 138.761 444.548 140.424 445.121 142.18C445.697 143.939 445.885 145.737 445.686 147.579C445.487 149.422 444.777 151.204 443.552 152.925C442.553 154.331 441.465 155.396 440.291 156.12C439.115 156.845 437.891 157.376 436.619 157.714C435.346 158.053 434.062 158.277 432.769 158.389C431.471 158.499 430.246 158.605 429.089 158.708C427.932 158.81 426.843 159.002 425.826 159.283C424.806 159.563 423.968 160.054 423.315 160.752C422.969 161.088 422.575 161.308 422.129 161.415C421.683 161.521 421.268 161.437 420.882 161.161L416.875 158.313C416.489 158.039 416.245 157.656 416.147 157.162C416.049 156.669 416.153 156.241 416.463 155.879C417.509 154.558 418.652 153.56 419.899 152.886C421.145 152.214 422.421 151.718 423.73 151.404C425.035 151.09 426.34 150.894 427.641 150.813C428.94 150.732 430.16 150.633 431.302 150.518C432.441 150.404 433.457 150.202 434.352 149.911C435.245 149.62 435.955 149.107 436.48 148.369C437.429 147.034 437.646 145.537 437.134 143.877C436.622 142.217 435.435 140.725 433.575 139.402C430.587 137.279 427.327 137.211 423.799 139.199C423.348 139.46 422.958 139.621 422.629 139.676C422.296 139.732 421.905 139.597 421.448 139.273L417.178 136.238C416.863 136.014 416.665 135.715 416.586 135.343C416.507 134.968 416.594 134.608 416.842 134.256C417.75 133.051 419.02 132.063 420.654 131.292C422.287 130.521 424.076 130.049 426.026 129.875C427.974 129.7 430.002 129.858 432.11 130.354C434.215 130.846 436.201 131.756 438.066 133.08Z" fill="white"/>
</g>
<path d="M315.831 287.029H266.662V167.888C266.662 146.343 284.128 128.876 305.674 128.876H310.218C331.764 128.876 349.23 146.342 349.23 167.888V253.634C349.229 272.078 334.276 287.029 315.831 287.029Z" fill="#263238"/>
<path d="M261.882 573.833C261.477 576.825 260.618 580.318 260.457 588.786C260.286 597.862 258.618 601.084 258.397 608.534C258.145 617.046 259.615 620.232 263.069 625.015C266.524 629.799 275.589 634.141 279.42 626.053C283.298 617.869 282.758 612.669 281.533 604.318C280.267 595.686 280.106 590.919 279.371 584.335C278.725 578.532 277.95 574.124 277.95 574.124L261.882 573.833Z" fill="#263238"/>
<path d="M287.648 513.532L257.748 512.99C258.192 532.95 261.364 555.105 261.882 573.832C261.979 577.357 261.793 601.225 263.124 608.479C265.121 619.376 278.057 617.905 278.743 611.382C279.43 604.861 277.91 576.997 277.952 574.122C277.838 562.112 283.467 541.838 286.419 520.278C286.563 519.219 287.511 514.565 287.648 513.532Z" fill="#FFA8A7"/>
<path d="M326.056 558.3C326.056 558.3 324.876 557.667 324.632 558.926C324.343 560.425 323.911 563.514 323.288 565.975C322.423 569.395 321.704 575.027 322.223 577.813C322.742 580.599 329.238 584.187 333.455 585.482C339.678 587.392 343.947 590.513 347.356 593.721C351.533 597.653 360.547 601.366 366.685 601.322C373.948 601.269 379.012 598.903 381.405 595.014C383.905 590.952 379.224 590.653 370.923 585.268C369.038 584.044 366.893 582.662 364.479 581.085C351.328 572.495 346.513 567.891 342.793 559.3L326.056 558.3Z" fill="#263238"/>
<path d="M342.897 552.983C342.676 546.802 346.915 494.376 346.915 494.376L318.52 507.321C324.601 543.613 325.896 552.172 326.004 558.111C325.957 558.249 325.837 558.753 325.844 559.632C325.87 566.683 333.827 570.485 340.034 575.187C342.486 577.043 349.617 582.526 356.822 586.147C361.332 588.414 370.49 588.62 371.625 585.717C364.071 579.949 353.085 571.317 347.077 564.729C344.208 561.582 343.119 559.163 342.897 552.983Z" fill="#FFA8A7"/>
<path d="M270.001 318.785C259.1 342.726 259.1 361.238 260.902 391.783C262.555 419.802 265.19 444.468 265.19 444.468C264.768 449.441 257.858 459.142 256.963 481.113C256.128 501.655 258.378 527.767 258.378 527.767C258.378 527.767 273.89 536.364 285.36 527.692C285.36 527.692 296.428 474.838 299.672 449.126C302.503 426.688 307.421 398.017 307.421 398.017L317.84 449.005C317.84 449.005 313.876 461.575 312.949 471.151C311.483 486.276 319.942 515.974 319.942 515.974C319.942 515.974 335.971 520.757 345.76 512.076C345.76 512.076 349.42 463.791 350.786 445.571C352.616 421.174 348.768 355.125 345.758 320.16L270.001 318.785Z" fill="#455A64"/>
<path d="M307.422 398.017L311.729 359.636C311.729 359.636 331.023 357.057 339.763 348.84C339.763 348.84 333.196 360.873 317.03 363.208L310.803 398.922L317.842 449.005L307.422 398.017Z" fill="#263238"/>
<path d="M385.544 309.355C386.745 297.591 386.7 289.753 386.596 288.246C386.175 282.155 385.086 281.164 376.57 270.372C365.075 255.801 355.263 242.706 344.885 229.677C337.476 220.375 329.689 218.944 322.082 219.364C316.763 219.659 327.139 245.22 332.367 260.346L362.193 292.427C363.111 293.693 363.533 295.253 363.379 296.809L361.548 324.121L370.481 336.069C370.481 336.069 384.006 324.407 385.544 309.355Z" fill="#FFA8A7"/>
<path d="M293.349 220.192C287.58 220.589 277.089 221.512 277.089 221.512C271.036 224.891 269.506 227.66 268.38 235.7C267.901 239.119 270.688 248.246 273.083 261.211L277.626 285.257L277.134 297.181C274.775 304.457 269.44 313.501 264.741 326.832C287.848 339.728 307.229 340.205 324.804 337.95C338.207 336.229 345.298 332.985 347.662 329.783C347.169 316.612 346.238 308.481 346.01 294.722C345.914 288.942 346.262 283.111 346.486 276.46C355.478 269.073 355.58 256.79 350.675 248.85C339.281 230.403 328.202 218.789 320.864 219.384L293.349 220.192Z" fill="#0CAF60"/>
<path opacity="0.6" class="theme-color" d="M293.349 220.192C287.58 220.589 277.089 221.512 277.089 221.512C271.036 224.891 269.506 227.66 268.38 235.7C267.901 239.119 270.688 248.246 273.083 261.211L277.626 285.257L277.134 297.181C274.775 304.457 269.44 313.501 264.741 326.832C287.848 339.728 307.229 340.205 324.804 337.95C338.207 336.229 345.298 332.985 347.662 329.783C347.169 316.612 346.238 308.481 346.01 294.722C345.914 288.942 346.262 283.111 346.486 276.46C355.478 269.073 355.58 256.79 350.675 248.85C339.281 230.403 328.202 218.789 320.864 219.384L293.349 220.192Z" fill="white"/>
<path opacity="0.1" d="M328.599 276.661C328.599 276.661 318.045 284.851 306 280.58C293.957 276.309 292.197 265.78 292.197 265.78C292.197 265.78 290.919 279.549 306.112 284.245C320.776 288.775 328.599 276.661 328.599 276.661Z" fill="black"/>
<path d="M342.909 182.396C342.455 202.377 335.97 207.317 332.72 208.735C329.471 210.154 323.197 209.289 317.11 208.281V220.272C317.11 220.272 324.135 227.638 323.609 233.13C323.071 238.635 312.569 239.245 304.679 233.867C298.92 229.945 294.807 225.461 293.012 223.334C292.359 222.56 292.006 221.588 292.006 220.575V192.358C292.006 192.358 288.67 195.892 282.768 191.848C276.879 187.817 276.368 180.295 279.972 176.038C282.541 173.016 289.069 172.802 292.205 177.5C293.964 180.949 294.206 184.411 296.179 182.978C301.443 179.188 298.62 170.574 304.977 166.317C304.991 166.317 304.991 166.303 305.004 166.303C306.906 165.282 309.064 164.316 311.476 163.478C322.815 159.562 332.636 156.269 335.005 148.52C339.474 151.175 343.463 158.824 342.909 182.396Z" fill="#FFA8A7"/>
<path d="M320.56 200.249C322.009 200.249 323.183 199.074 323.183 197.626C323.183 196.177 322.009 195.003 320.56 195.003C319.112 195.003 317.938 196.177 317.938 197.626C317.938 199.074 319.112 200.249 320.56 200.249Z" fill="#B16668"/>
<path d="M318.806 179.367C318.886 180.951 317.714 182.292 316.19 182.366C314.665 182.438 313.365 181.213 313.285 179.628C313.206 178.045 314.377 176.702 315.902 176.629C317.426 176.559 318.727 177.783 318.806 179.367Z" fill="#263238"/>
<path d="M339.78 179.639C339.853 181.079 338.788 182.299 337.401 182.364C335.877 182.436 334.841 181.461 334.76 179.877C334.688 178.438 335.753 177.217 337.139 177.151C338.526 177.086 339.708 178.2 339.78 179.639Z" fill="#263238"/>
<path d="M315.252 186.482C310.289 186.482 306.25 182.443 306.25 177.48C306.25 171.36 312.557 171.36 315.252 171.36C317.946 171.36 324.253 171.36 324.253 177.48C324.253 182.445 320.215 186.482 315.252 186.482ZM315.252 172.78C309.796 172.78 307.67 174.098 307.67 177.482C307.67 181.663 311.07 185.063 315.252 185.063C319.433 185.063 322.833 181.663 322.833 177.482C322.833 174.098 320.707 172.78 315.252 172.78Z" fill="#455A64"/>
<path d="M338.103 186.482C333.14 186.482 329.102 182.443 329.102 177.48C329.102 171.36 335.408 171.36 338.103 171.36C340.798 171.36 347.105 171.36 347.105 177.48C347.105 182.445 343.066 186.482 338.103 186.482ZM338.103 172.78C332.647 172.78 330.522 174.098 330.522 177.482C330.522 181.663 333.922 185.063 338.103 185.063C342.284 185.063 345.685 181.663 345.685 177.482C345.685 174.098 343.559 172.78 338.103 172.78Z" fill="#455A64"/>
<path d="M325.651 174.579L326.094 191.39L334.942 188.648L325.651 174.579Z" fill="#F28F8F"/>
<path d="M317.104 208.277C310.678 207.434 297.458 203.637 295.398 198.411C295.398 198.411 296.085 201.695 300.033 205.08C303.982 208.464 317.104 212.278 317.104 212.278V208.277Z" fill="#F28F8F"/>
<path d="M317.407 166.417L311.545 169.99C310.584 168.303 311.119 166.136 312.738 165.149C314.357 164.162 316.448 164.73 317.407 166.417Z" fill="#263238"/>
<path d="M341.29 170.401L334.759 168.12C335.326 166.278 337.247 165.297 339.051 165.927C340.854 166.555 341.856 168.559 341.29 170.401Z" fill="#263238"/>
<path d="M323.542 178.197C323.15 178.197 322.833 177.873 322.833 177.48C322.833 176.329 325.111 175.584 327.155 175.584C329.199 175.584 330.52 176.329 330.52 177.48C330.52 177.872 330.203 178.19 329.81 178.19C329.418 178.19 329.1 177.873 329.1 177.48C329.036 177.35 328.381 177.004 327.154 177.004C325.926 177.004 324.315 177.35 324.249 177.493C324.25 177.886 323.933 178.197 323.542 178.197Z" fill="#455A64"/>
<path d="M306.983 177.598C306.957 177.598 306.931 177.597 306.903 177.594L291.082 176.153C290.799 175.89 290.05 175.116 288.49 174.47L307.061 176.183C307.45 176.226 307.731 176.578 307.688 176.968C307.646 177.329 307.339 177.598 306.983 177.598Z" fill="#455A64"/>
<path d="M242.033 194.086C247.206 187.174 250.734 181.951 255.456 176.026C258.137 172.661 259.852 170.26 262.431 166.808C264.207 164.432 265.248 162.428 267.216 161.692C269.43 160.863 271.566 159.224 272.99 157.728C274.007 156.658 274.84 155.43 275.721 154.244C278.677 150.26 282.209 146.703 286.171 143.718C290.336 140.58 294.962 138.187 299.235 135.198C301.784 133.414 304.518 130.451 301.415 127.685C300.489 126.859 299.312 126.366 298.1 126.102C290.57 124.457 283.998 127.053 276.633 128.937C273.431 129.754 270.282 130.78 267.253 132.105C265.784 132.747 264.318 133.446 263.1 134.488C261.201 136.113 260.065 138.425 258.832 140.597C255.52 146.432 248.659 151.58 243.83 156.122C238.166 161.451 233.103 166.336 226.641 172.216C220.826 177.507 215.136 182.385 209.802 188.163C205.39 192.944 206.995 196.683 207.624 197.975C211.219 205.371 215.245 208.022 220.055 212.603C228.385 220.539 257.078 243.367 266.597 250.902C268.635 252.514 270.234 254.605 271.263 256.991L273.08 261.212C283.931 263.209 291.17 246.918 282.184 227.303C280.727 224.121 278.414 221.413 275.586 219.35C264.261 211.088 242.033 194.086 242.033 194.086Z" fill="#FFA8A7"/>
<path d="M242.033 194.086C242.033 194.086 237.127 200.644 228.771 203.213C228.771 203.213 235.693 204.979 245.166 196.477L242.033 194.086Z" fill="#F28F8F"/>
<path d="M382.728 294.913L382.763 294.917L380.989 293.388L380.988 293.41C380.588 293.089 379.966 292.988 379.164 293.206L359.947 298.434C358.166 298.918 356.232 300.724 355.629 302.468L341.8 342.367C341.48 343.292 341.607 344.005 342.055 344.406L342.039 344.411L343.869 345.988L343.868 345.964C344.266 346.296 344.894 346.403 345.71 346.182L364.926 340.956C366.708 340.471 368.641 338.664 369.245 336.92C371.961 329.077 380.359 304.861 383.075 297.019C383.415 296.035 383.247 295.296 382.728 294.913Z" fill="#455A64"/>
<path d="M343.579 343.899L357.407 304C358.011 302.256 359.944 300.45 361.726 299.966L380.942 294.74C382.724 294.255 383.677 295.277 383.074 297.021C380.358 304.862 371.96 329.078 369.245 336.921C368.641 338.665 366.707 340.473 364.927 340.957L345.71 346.183C343.929 346.665 342.975 345.643 343.579 343.899Z" fill="#D1734A"/>
<path d="M359.635 301.073C358.635 301.863 357.774 302.951 357.406 304.004L343.572 343.891C343.274 344.786 343.362 345.488 343.765 345.892L342.045 344.417L342.063 344.399C341.606 343.995 341.483 343.293 341.8 342.363L355.633 302.458C355.966 301.476 356.756 300.475 357.686 299.685L359.635 301.073Z" fill="#37474F"/>
<path d="M377.447 313.094C376.092 317.159 371.264 319.87 363.326 321.751C355.389 323.632 350.992 332.061 352.274 334.625C353.557 337.19 366.382 339.572 371.513 338.839C376.643 338.106 381.804 330.69 383.357 328.396C384.91 326.101 386.72 310.073 385.072 307.875C383.422 305.676 379.958 306.014 379.958 306.014L377.447 313.094Z" fill="#F28F8F"/>
</svg>
                    </div>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="login-form-wrp">
                        <h2 class="mb-4 text-center">{{ __('Forgot Password ?') }}</h2>
                        <form method="POST" class="needs-validation" novalidate action="{{ route('password.email') }}"
                            id="form_data">
                            @csrf
                            <div class="row">
                                @if (session()->has('info'))
                                    <div class="alert alert-success">
                                        {{ session()->get('info') }}
                                    </div>
                                @endif
                                @if (session()->has(key: 'status'))
                                    <div class="alert alert-success">
                                        {{ session()->get('status') }}
                                    </div>
                                @endif

                                @if (session('Error'))
                                    <div class="alert alert-danger">
                                        {{ session()->get('Error') }}
                                    </div>
                                @endif

                                @if (session('error'))
                                    <div class="mb-4 font-medium text-lg text-green-600 text-danger">
                                        {{ __('Email SMTP settings does not configured so please contact to your site admin.') }}
                                    </div>
                                @endif
                                <div class="col-12 form-group mb-3">
                                    <label for="email" class="form-label d-flex">{{ __('Email') }}</label>
                                    <input type="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}"
                                        id="email" name="email" placeholder="{{ __('Email address') }}" required=""
                                        value="{{ old('email') }}">
                                        <div class="invalid-feedback d-block">
                                            {{ $errors->first('email') }}
                                        </div>
                                </div>
                                <div class="col-12 text-center">
                                    <button class="btn btn-primary login-do-btn mt-2"
                                        id="login_button">{{ __('Reset Password') }}</button>
                                </div>
                            </div>
                            <p class="mt-3 mb-0 text-center">{{ __('Back to? ') }}
                                <a href="{{ route('login', $lang) }}" class="my-4 text-primary">{{ __('Login') }}</a>
                            </p>
                        </form>
                    </div>
                </div>
            </div>
            @include('layouts.footer')
        </div>
    </div>
    </div>



@endsection