<?php

namespace RachidLaasri\LaravelInstaller\Controllers;

use App\Facades\AddonFacade as AddOnFacade;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use RachidLaasri\LaravelInstaller\Helpers\DatabaseManager;
use RachidLaasri\LaravelInstaller\Helpers\InstalledFileManager;

class UpdateController extends Controller
{
    use \RachidLaasri\LaravelInstaller\Helpers\MigrationsHelper;

    public function welcome()
    {
        return view('vendor.installer.update.welcome');
    }

    public function overview()
    {
        $alreadyRunnedMigrations = DB::table('migrations')->pluck('migration');
        $getAllModules = AddonFacade::allModules();

        $baseMigrationsFiles = collect(File::glob(database_path('migrations/*.php')))->map(function ($path) {
            return File::name($path);
        });

        foreach ($getAllModules as $key => $module) {
            $directory = "packages/workdo/" . $module->name . "/src/Database/Migrations";
            $modulesMigrations = collect(File::glob("{$directory}/*.php"))->map(function ($path) {
                return File::name($path);
            });
            // Merge Modules Migrations files with basecode migrations files collection
            $baseMigrationsFiles = $baseMigrationsFiles->merge($modulesMigrations);
        }
        // Count Total Pending Migrations
        $pendingMigrations = $baseMigrationsFiles->diff($alreadyRunnedMigrations);

        return view('vendor.installer.update.overview', ['numberOfUpdatesPending' => count($pendingMigrations)]);
    }

  
    public function database()
    {
        $databaseManager = new DatabaseManager;
        $response = $databaseManager->migrateAndSeed();

        return redirect()->route('LaravelUpdater::final')
            ->with(['message' => $response]);
    }


    public function finish(InstalledFileManager $fileManager)
    {
        $fileManager->update();

        return view('vendor.installer.update.finished');
    }
}
